#Eneroth Railroad System

#Author: Julia Christina Eneroth, eneroth3@gmail.com

#Usage
#	See Plugins > Railroad > Documentation

#Copyright Julia Christina Eneroth (eneroh3)

#Known bugs and issues
#	*Comments starting with 'NOTE:' is often about bugs but could be bad code, planned features or half baked ideas
#	*Offset Bezier curve approximation is decent but perhaps could be better
#	*Commands not visually updating (checked or not) when setting active tool from within a tool (Switching to native tools with Sketchup.send_action works though), affects ToolTrainDrive switching to ToolRStockInsert 
# *No intuitive, user friendly way to stop following rolling stock with camera if not in drive train tool (no context menu when clicking in empty space outside custom tool)
# *Custom cursors covers tooltip
# *Copying track in SU 2013 using move tool mixes up groups and redraws the wrong one.
# *Occasional bug splats
# *Changing track type (or other properties) for a track that isn't automatically redrawn should prompt the user.

#Changelog
#	0.1.0 2013-08-24
#		*First beta release
#	0.1.1 2013-08-30
#		*Second beta release
#		*Started working on offset mode for insert tool(control vector length doesn't scale making beziers quite bad)
#		*Better connect mode in insert tool. Suggest the shortest possible connection that isn't an existing track
#		*Hopefully solved a mac bug I don't even know if it existed. html form initializing requiring form data to be set is called from dialog.show{}, and no loner window.onload
#		*Fixed insert track tool deactivation from always switching to select tool
#		*Using symbols and not strings as hash keys
#		*More consistent file names
#	0.1.2 2013-09-05
#		*Third beta release
#		*Consistent class names
#		*Using relative paths (thanks to Andreas Eisenbarth's feedback :) )
#		*Create cursor object on initialing, not set cursor since it eats up memory (thanks to Andreas Eisenbarth's feedback :) )
#		*Saving track parameters as class variables of insert tool so they are kept when tool is deactivated. (thanks to Andreas Eisenbarth's feedback :) )
#		*Insert tool is set to connect by default when 2 unselected tracks are selected on initialization
#		*Now possible to change curve algorithm from position tool context menu
#		*Decent bezier offset approximation
#		*Started working on moving rolling stocks
#	0.1.3 2013-09-16
#		*Fourth Beta
#		*Started on insert rolling stock tool
#		*Model specific animate object
#		*Done a lot to drive tool, follow with camera is still a missing feature though
#		*Removing several tracks at once now removes all their track objects
#		*Remove track, rolling stock and train objects when unloading their model
#		*Animation speed calibrated to be exact no matter fps
#		*Stops animation when a model is deactivated (either unloaded or because user switches to another model)
#		*Removed bounce at track ends bug. was caused by the start_segment variable not changing when reversing path if variable was 0 from the start. No idea what that condition was there for...
#		*Save track paths to objects rather than calculate for every point in moving trains every frame.
#			Use this code to convert older files: EneRailroad::Track.instances.each{|t| path = EneRailroad::Track.calc_path(t.controls, t.curve_algorithm, t.segments); t.group.set_attribute(ID,"path",path)}
#		*Written in insert rolling stock tool that it isn't implemented
#	0.1.4 2013-09-22
#		*Fifth Beta
#		*Click on train speed slider to set speed (doesn't have to be dragged)
#		*Keep selected trains when re-activating drive tool
#		*Train speed changed from integer to float, much smoother accelerations
#		*Now possible to follow train with camera
#		*Creating type of track selector in track properties dynamically from JSON object
#		*Loading track info dynamically (rather than hard coded in properties form) so tracks can be easily distributed
#		*Started on documentation for custom tracks
#		*Open rolling stock folder button in insert rolling stock tool
#		*Loading rolling stock list from folder
#		*Train collisions (for trains on same track, not crossings)
#		*Splitting train in 2 (method, not the tool/UI)
#		*Joining 2 trains into one (method, not tool/UI)
#		*Started on coupling tool, learned Array.map method
#		*Finished UI of couple tool and split (no join yet)
#		*Implemented join to coupling tool
#	0.1.5 2013-10-28
#   *Styled code
#   *Cleaned up menu code
#   *Right click on train to drive
#   *Recoded follow with camera to affect individual rolling stock, still possible to follow train (its first rs) just as before
#   *Move camera to front of train if not visible, when enabling follow, changing train or reversing train
#   *Rotating bogies to fit track segment they are on
#   *Couplings pointing towards neighboring rolling stock
#   *Fixed bug when attribute keys are symbols and not strings when loading tracks from groups
#   *Escaped non standard characters that differs between common encodings
#   *Changed gauge to 1,435 m from 1,4 m
#     Use this code to fix old tracks in file (may take several minutes):  EneRailroad::Track.instances.each do |t|; Sketchup.active_model.start_operation "Fix gauge"; t.draw; Sketchup.active_model.commit_operation; end;
#   *Not calling Bavarian signals slip & Y-switch signals anymore, nut Bavarian
#   *Not automatically use the Bavarian style switch indicators by default on slips
#   *Copy track properties when copying or offsetting tracks
#   *Removed complicated system keeping track on tracks manually edited. Only warn user when opening track group not to manually edit it.
#   *Joining trains sets proper train_location for rolling stocks, telling where in the train they are
#	0.1.6 2013-10-30
#   *Set html meta tag telling IE to render web dialogs as IE8. For some reason the computers at my school rendered pages as IE7 even though IE10 was installed, rendering drive tool form useless since lacking css support placed it partly outside the window
#   *Simple system to add rolling stocks (not the planned fancy one).
#     Place a group you wish to convert into a rolling stock on a track
#     Draw an edge in the same plane as the top of the tracks, each end of the edge represents one of the points that will follow the track (should be placed between the wheel or at center of bodie)
#     Run "g_e_2_rs" in console (group and edge to rolling stock)
#     Optionally if you want rotating bogies, put the wheels in either groups or components.
#     Make sure the component origin is in the same horizontal plane as the top of the tracks and on the axis the bogie should rotate around.
#     Name the track/component closest to the rolling stock group origin "bogie0" and the other "bogie1"
#   *Fixed buffer stop measurements
#	0.1.7 2013-12-15
#   *Created DRG class 01 and wagon to add to rolling stock library
#   *Added Swedish mechanic turnout indicators
#   *Fixed structure gauge for tunnels (based on loading gauge UIC-C, I haven't found documents for structure gauge itself)
#   *Switch tool now shows what direction switches are set to, before you select the switch
#   *Loading signal types dynamically
#   *Unloading rolling stocks (and split train) when deleting group
#   *Changed encoding to utf-8 without BOM
# 0.1.8 2014-02-08
#   *Fixed rolling stock couplings not point at each other but as they should in previous frame
#   *Moved ss_track, ss_rs, and ss_train into EneRailroad module
#   *Added method to edit track type, rolling stock and signal properties (called from console)
#   *Cleaned up code and moved parts into individual methods
#   *Track properties dialog handles missing track types and signal types better
#   *Insert rolling stock tool can now create new rolling stocks (not save to library though since that isn't implemented)
#   *UI for inserting rolling stocks from library (doesn't insert anything yet)
#   *Coupling tool works for 0 buffer distance (required for Jacob's boogie)
#   *Method on rolling stock to change number plates
#   *Merge track extrusion profiles to 1 file per track type. Before each extruded face required it's own sketchup model.
#     For old models, purge components and run:
#     used_track_types = EneRailroad::Track.instances.map {|t| t.type_of_track }.uniq
#     used_track_types.each { |tt| EneRailroad::Track.preload_track_type tt }
#     used_signal_types = EneRailroad::Track.instances.map {|t| t.type_of_signals }.uniq
#     used_signal_types.each { |st| EneRailroad::Track.preload_signal st }
#     i=0; total= EneRailroad::Track.instances.length; EneRailroad::Track.instances.each { |t| puts "Drawing track #{i}/#{total}";  Sketchup.active_model.start_operation "Update Tracks"; t.draw_extrude; Sketchup.active_model.commit_operation; i+=1 }
#     This may take many many many minutes
#   *Simplified making preview images for custom track types
#   *Removed function to turn group into rolling stock using edge to define points
#   *Cleaned up code
#   *Track and signal types can now be set in Insert Track Tool
#   *When moving a track end using track positioning tool, the end is put on the same level as the other end and not on the x y plane, when placed in free space. Useful for drawing railroads at other levels than z = 0.
#   *Track positioning tool snaps end point to straight line
#   *Press shift in track positioning tool to lock to straight track
#   *Fixed 0 buffer distance bug. Jacob's bogies now works
#   *Using @@instances ||= [] instead of @@instances = [] in several classes so their files can be reloaded without losing the object lists
#   *Drawing arrows telling direction of rolling stocks being placed (and adding feature to change whether front or back is being placed)
#   *Placing rolling stocks from library
#   *Adjusted speed slider in drive train tool to 50 m/s maximum (higher speeds can be written in text field) to improve low speeds
#   *Show pause symbol when animation is paused and Drive Tool is activated
#   *Removed window.onload in all dialogs and moved code to Webdialog.show
#   *Updating group name instead of using deprecated Group.make_unique
#   *Alt now works in track position tool without putting focus to the menu from of the viewport
#   *Method that saves current model to rolling stock library
#   *Grouping in rolling stock library
#   *Moved cursors and toolbar icons to own directories
#   *Cleaned up code, renamed some methods, removed some methods not called and fixed several smaller bugs
#   *Whole plugin can now be reloaded without re-initializing existing objects for tracks, rolling stocks and trains
#   *Saving train speed along with model
# 0.1.9 2014-04-22
#   *GUI for changing texts on rolling stocks
#   *Started working on system to run custom ruby code when train reaches certain points along track,
#     e.g. changing speed or reversing.
#   *Now possible to set target speed and acceleration used to reach it for train, instead of just speed
#   *Fixed bug with r_stock_inser_tool not functioning as expected with 0 length buffer distance
#   *Preventing rs insert tool from creating rolling stocks with 0 length wheelbase
#   *Headlights that adapts to direction of travel
#   *Cleaned up code, renamed some methods in Track and made their output more consistent
#   *Changed system to keep track of what track switch is set to.
#     saving the index of the target track counting from left to right instead of the point at the other end of track.
#     Makes it easier to set switch state from Balise.
#     All switches in old files are reset to leftmost track and must manually be changed.
#   *Switch indicators can now differ outgoing tracks in curved switches where both outgoing tracks turn by the same angle.
#   *Switch indicator are now positioned on the side of the track where there's most space, or by default the riht side.
#   *Switches are now created with straight as default outgoing track in track insert tool and drawn with switch indicators from the start
#   *Switch indicators are now removed when not needed after connected tracks are removed
#   *Text can be changed for whole train as well as single rolling stock
#   *Sorted methods alphabetically in Track, RStock, Train and Balise class
#   *Possibility to move certain parts when rolling stock moves, such as coupling rods and wheel axes.
#   *Smooth bogie rotation (not to match current segment of the polyline track).
#   *Tilting car bodies.
#   *Moved out docs to own dictionary (with links from old locations, e.g. track folder).
#   *Documented tools.
#   *Using some Win32Api to remove minimize and maximize buttons on web dialogs.
#   *Traded track mix up bug (copied track's group having same definition as original track's group) to undo stack bug (undo stack now breaks at add track)
# 0.1.10 2014-05-21
#   *Disabled UI for all start_operation, prevents SU from crashing when drawing track with outliner open and speeds up drawing(!) :D
#   *Prevented Drive Train dialog from setting v and v_target to current v when shown. Now train acceleration is kept until user clicks dialog.
#   *Written importer for TCZ (model railway planning program my dad made during prehistorical times). Example for bulk adding tracks to model and using the importer interface.
#   *Changed global variables into module class variables.
#   *Individual tracks can set to not be automatically redrawn to prevent manually drawn content from being lost.
#   *Key events in web dialogs in tools are now ported back to ruby so keys within the tool works even when the web dialog is focused.
#   *Rolling stock insert tool's create mode direction of travel input no longer takes edge position from pickhelper and transform to global coordinates by info from input point. instead all info is taken from input point which prevents coordinates from being faulty when the 2 classes finds different points due to inference.
#   *Move parts inside rolling stocks (e.g. bogies) when inserting to match track.
#   *Uses system font in web dialog.
#   *Inspect methods more consistent to Sketchup's own.
#   *Prevent observer to be called and redraw tracks that are changed from track properties dialog (prevents the same tracks from being drawn twice).
#   *Drive train tool remembers follow with camera state when re-activating tool.
#   *Button to focus camera to train at any time.
#   *Smooth acceleration option.
#   *Trains in alphabetic order.
#   *Warn in train drive tool if train isn't on tracks.
#   *Make rolling stocks look for tracks under them when tracks changes (observers).
#   *Undo/Redo on works on track positioning.
#   *Fixed bug with train name not changing when splitting train.
# 0.1.11 2014-06-17
#   *Fixed Mac error on plugin load (changing separators in PLUGIN_ROOT).
#   *Making web dialogs "modal" on mac.
#   *Fixed errors occurring when loading model with rolling stocks but no track, e.g. editing rolling stock in library.
#   *Make bogies and tilt group unique when placing rs so text and moving parts doesn't get mixed up between instances.
#   *Prevent switch indicators from being drawn on manually edited tracks.
#   *Hidden edges in track profiles are now extruded to hidden faces bond by hidden edges. This can be used for double tracks to hide the border between each half.
#   *(Hopefully) fixed create rolling stock dialog on Mac.
#   *(Hopefully) fixed rolling stock library on Mac.
# 0.1.12 2014-07-01
#   *Connect track ends in Track Insert Tool now uses track and signal type from one of the tracks being connected.
#   *Using ThomThom's Babelfish to add translations.
#   *Added Oxer's Spanish translation.
#   *Started working on better interface to save rolling stocks to library.
#     Less buggy (last one could crash SU if it wasn't restarted).
#     Nicer looking dialog with help texts.
#     Suggests IDs.
#     Saves user prefix.
#     Generates image automatically (but a little buggy).
#  0.1.13 2014-07-09
#   *Improved documentation for rolling stocks and tracks.
#   *Save rolling stock to library without using console.
#   *Advanced animation settings.
# 0.1.14 2014-07-31
#   *Fixed bug preventing it from being just 1 along-object for short arc tracks.
#   *Started working on system for structures following tracks, e.g. platforms or catenary.
#   *Allowed "None" as signal type for track.
#   *Added last_train and last_run reference to balise.
#   *Fixed track insert tool for tiny tracks (e.g. model trains in model).
#   *Cleaned up switch indicator system.
#     Use this code to update tracks in existing models:
#     EneRailroad.disable_observers = true; Sketchup.active_model.start_operation "Fix Signals", true; EneRailroad::Track.instances.each{|t| t.draw_endings if t.connections.any?{ |c| c.length > 1} }; Sketchup.active_model.commit_operation; EneRailroad.disable_observers = false
#     Please note that this code will remove tracks with track types no longer present in the track/ folder.
#   *Documented how to make custom switch indicators.
#   *Track properties supporting multiple tracks.
#   *Split existing track types into track types and structure types.
#     To get rid of obsolete track types, remove all track types from the tracks/ folder except your custom ones before updating.
#     Backup of these folders may be useful when working on models containing them.
#   *Fixed bug with imperial units in Track Insert Tool.
#   *Allow user to type in exact length and radius when positioning arc track.
# 0.1.15 2014-08-12
#   *New add track mode. Click on screen to add nodes that are automatically connected.
#   *Made tilting cars smoother.
#   *Made Bezier curves smoother.
#   *Improved trains' behavior at trailing switches.
# 0.1.16 2014-08-21
#   *Styles Add Track dialog.
#   *Prevent train from trigger balise on wrong track.
#   *Fixed problem with translation on Mac in Advanced Animation Settings.
#   *Show warning in tooltip if nodes are too close in Add Track tool continuous mode.
# 0.1.17 2014-09-18
#   *Improved tool drawing for add track tool (bounding box now depends on content).
#   *Started working on "auto pilot" for trains.
#   *Finished random mode for autopilot.
#   *Improved Track.path_between_points. No returns switch-states and find shortest path more reliably.
#   *Finished guided mode for autopilot.
# 0.1.18
#   *Changed default values in Add Track Tool for JPods edition.
#   *Made available for SU8.
#   *Renamed module EneRailroad.
#   *Added Library mode to Add Track Tool.
#   *Changed save location and save format for templates (e.g. track types).
#    To keep custom templates, run EneRailroad::Templates.convert_old.
#   *Improved methods for customizing content and documentation for it.
# 0.1.19
#   * Fixed bug with switch tool not working.
#   * Fixed bug with tracks not connecting properly when placing from track
#     library.
#   * Fixed bug with rolling stock save on model save.
# 0.1.20 2015-02-26
#   * Fixed character encoding.
# 0.1.21
#   * Fixed bug with warning for manually editing structure showing when entering it even if it is already set to not be automatically redrawn.
#   * Added warning for potentially harmful balise code in models and track formations.
#   * Fixed various errors caused by model using non-installed templates for tracks, structures and signals.
#   * Added back translation support.
#   * Added feature for manually tweaking structure part positions by coordinates.

# Load support files.
require "sketchup.rb"
require "extensions.rb"

module EneRailroad

# Public: ID of plugin.
ID = "ene_railroad"

# Public: Whether this is the JPOD edition of the plugin or not.
# This changes the default settings on some tools.
#
# When publishing, make sure this constant is correct and include the matching
# content (tracks, signals, structures and rolling stocks).
JPOD = true

# Public: Path to loader file's directory.
PLUGIN_ROOT = File.expand_path(File.dirname(__FILE__))

# Public: Path to plugin's own directory.
PLUGIN_DIR = File.join PLUGIN_ROOT, ID

# Load translations.
require File.join(PLUGIN_DIR, "lang.rb")
S = Lang.new(File.join(PLUGIN_DIR, "lang"))
lang = Sketchup.read_default(ID, "language", S.guess_l10n)
S.load lang

# Public: General extension information.
AUTHOR      = "Julia Christina Eneroth"
CONTACT     = "#{AUTHOR} at eneroth3@gmail.com"
COPYRIGHT   = "#{AUTHOR} #{Time.now.year}"
DESCRIPTION = "Draw parametric railroads and run trains on them."
NAME        = S.tr(JPOD ? "Eneroth Railroad System - JPods Edition" : "Eneroth Railroad System")
VERSION     = "0.1.21"

# Create Extension.
ex = SketchupExtension.new(NAME, File.join(PLUGIN_DIR, "main.rb"))
ex.description = DESCRIPTION
ex.version     = VERSION
ex.copyright   = COPYRIGHT
ex.creator     = AUTHOR
Sketchup.register_extension ex, true

end# Module