/*
	Eneroth Railroad System
	
	Copyright Julia Christina Eneroth (eneroh3)
	
	This file holds scripts shared by all ene_railroad web dialogs.
	Specific page scripts are embedded in page.
*/

function open_in_default_browser(link){
	//Open links in default browser rather than the one Sketchup uses
	window.location='skp:open_in_default_browser@' + link;
}

function port_key(e){
  //Sends the keycode from the event to a Ruby callback.
  //This can be used for web dialogs inside a custom tools to send key events to the tool to change its behavior even when the web dialog is focused.
  //Run "document.onkeyup=port_key;" to initialize. onkeyup is used to avoid overriding calls to onkeydown already in use in the dialog. onkeypress doesn't fire for modifier keys.
  e = window.event || e;
  keycode = e.keyCode || e.which
  
  //It might be wise to only proceed for certain keys here, e.g. modifier keys or whatever keys are used in the tool.
  
  window.location='skp:port_key@' + keycode;
}

function init_checkboxes(){
	//Ruby can't read data from checkboxes in IE, therefore the data is stored as a string "true" | "false" | ""(=nil) in a hidden input.
	//When page loads the checkbox state changes depending on this value. When checkbox is changed the hidden input changes value.
	//The hidden input has the id of the variable name and the checkbox the same id but with "_checkbox" appended.
  //Both checkbox and hidden input are manually written in HTML source.

	forms = document.forms;
	
	for(i=0;i<forms.length;i++){
		form = forms[i];
		elements = form.elements;
		for(j=0;j<elements.length;j++){
			element = elements[j];
			if(element.type == "checkbox"){
			
				id_checkbox = element.id;
				id_hidden = id_checkbox.replace("_checkbox", "");
				hidden_element = document.getElementById(id_hidden);
				element.checked = (hidden_element.value == "true");
				element.indeterminate = (hidden_element.value == "");
				if (element.indeterminate) element.setAttribute("toggle_indeterminate", "true");//If indeterminate at page load indeterminate should be toggleble.
				
				element.onclick=function(){//Must be called after checked changes but it seems like all browser are doing this right.
        
          //Toggle with indeterminate
          if(this.getAttribute("toggle_indeterminate") == "true"){
            if (this.readOnly) this.checked=this.readOnly=false;
            else if (!this.checked) this.readOnly=this.indeterminate=true;
          }
          
          //Save value to hidden input
					id_checkbox = this.id;
					id_hidden = id_checkbox.replace("_checkbox", "");
					hidden = document.getElementById(id_hidden);
          hidden.value = this.checked ? "true" : "false";
          if(this.indeterminate) hidden.value = "";
				};
				
			}
		}
	}
}

function init_radio_buttons(){
	//IE bring us down again. This time radio buttons cannot be read from ruby, therefore their value is stored in a hidden input.
	//When page loads the radio button state changes depending on this value. When radio buttons are changed the hidden input changes.
	//The hidden input has the id of the variable name and the radio buttons have it as name, with "_radio" appended.
	
	forms = document.forms;
	
	for(i=0;i<forms.length;i++){
		form = forms[i];
		elements = form.elements;
		for(j=0;j<elements.length;j++){
			element = elements[j];
			if(element.type == "radio"){
			
				name_radio = element.name;
				id_hidden = name_radio.replace("_radio", "");
				hidden_element = document.getElementById(id_hidden);
				element.checked = (hidden_element.value == element.value);
				
				element.onclick=function(){//Must be called after value changes but it seems like all browser are doing this right.
					name_radio = this.name;
					id_hidden = name_radio.replace("_radio", "");
					document.getElementById(id_hidden).value = this.value;
				};
				
			}
		}
	}
}

function init_tabs(){
	//Initialize tab view
	
	var elements = document.getElementsByTagName("*");
	for(i=0;i<elements.length;i++){
		if(elements[i].className == "toggle_menu"){
			menu_items = elements[i].getElementsByTagName("div");
			for(j=0;j<menu_items.length;j++){
				menu_items[j].onclick=function(){
				
					toggleble_index_counter = 0;
					tab_index_counter = 0;
					elements = document.getElementsByTagName("*");
					for(i=0;i<elements.length;i++){
						if(elements[i].className == "toggle_menu"){
							menu_items = elements[i].getElementsByTagName("div");
							for(j=0;j<menu_items.length;j++){
								if(menu_items[j] == this){
									toggleble_index = toggleble_index_counter;
									tab_index = tab_index_counter;
								}
								tab_index_counter++;
							}
							toggleble_index_counter++;
						}
					}
					change_tab(toggleble_index, tab_index);
				
				};
			}
		}
	}
}

function change_tab(toggleble_index, tab_index){
	//toggleble_index is the index of the togglable menu
	//tab_index is the index of the clicked tab
	
	var elements = document.getElementsByTagName("*");
	
	//Get reference to menu
	menu_counter = 0;
	for(i=0;i<elements.length;i++){
		if(elements[i].className == "toggle_menu"){
			if(menu_counter == toggleble_index) menu = elements[i]
			menu_counter++;
		}
	}
	
	//Get reference to toggle area
	toggle_counter = 0;
	for(i=0;i<elements.length;i++){
		if(elements[i].className == "togglable_content"){
			if(toggle_counter == toggleble_index) toggle_area = elements[i]
			toggle_counter++;
		}
	}
	
	//Select menu item
	menu_items = menu.getElementsByTagName("div");
	for(i=0;i<menu_items.length;i++){
		menu_items[i].className = "";
	}
	menu_items[tab_index].className = "selected";
	
	//Toggle content
	toggle_contents = [];
	divs = toggle_area.getElementsByTagName("div");
	for(i=0;i<divs.length;i++){
		if(divs[i].parentNode == toggle_area) toggle_contents.push(divs[i]);
	}
	for(i=0;i<toggle_contents.length;i++){
		toggle_contents[i].className = "";
	}
	toggle_contents[tab_index].className = "selected";
}

function init_input_sync(){
  //Sometimes the layout requires multiple copies of the same input in a form.
  //One is then the master and one is the slave (same id as master but with '_slave'= appended).
  //Syncing 2 inputs will occupy both their onchange and onkeyup events.
  //On init slave while automatically inherit master's value.
  
  var elements = document.getElementsByTagName("*");
  var pairs = [];
	for(i=0;i<elements.length;i++){
    if(elements[i].id && elements[i].id.indexOf("_slave") !== -1){
      slave = elements[i];
      if(slave.tagName == "SELECT" || slave.tagName == "INPUT"){
        master_id = slave.id.replace("_slave","");
        master = document.getElementById(master_id);
        slave.value = master.value;
        slave.onchange = sync;
        slave.onkeyup = sync;
        master.onchange = sync;
        master.onkeyup = sync;
      }
    }
  }
}

function sync(){
  //Take value from this and put in field either with same id + "_slave", or same id - "_slave".
  if(this.id.indexOf("_slave") === -1){
    id = this.id + "_slave"
  }else{
    id = this.id.replace("_slave","");
  }
  document.getElementById(id).value = this.value;
}

x_down = 0;
slider_div = 0;
slider_start = 0;
slider_width = 0;
function init_sliders(){
	//Initiate slider on pages
	//Slider returns value to a hidden input with the same id as the slider div but without "_slider" at the end.
			
	divs = document.getElementsByTagName("div");
	slider_index = 0
	for(i=0;i<divs.length;i++){
		slider_div = divs[i]
		if(slider_div.className == "slider"){
		
			button = slider_div.getElementsByTagName("button")[0];
			
			//Set slider position
			slider_update_value(slider_index);
			slider_index++;
			
			slider_div.onclick=function(e){
				//Move button to where slider was clicked
				if(!e) e = window.event;
				if(e.srcElement == button || e.target == button) return false;
				//Find total offset left of slider div
				el = slider_div;
				offsetLeft = 0;
				//while(el!=null) CURLY BRACKET This loop seems to include elements that shouldn't be included (body?), or perhaps offsetLeft is relative to the whole document and not just parent element
				  if(el.offsetLeft){
					offsetLeft+= el.offsetLeft
				  }
				  el = el.parentNode;
				// CURLY BRACKET
				//Find mouse position
				if(e.pageX){
					mouseX = e.pageX;
				}else{
					mouseX = e.clientX;//Assume no horizontal scroll
				}
				//Get difference, move slider and change input value
				slider_position = mouseX-offsetLeft;
				if(slider_position < 0) slider_position = 0;
				if(slider_position > slider_width) slider_position = slider_width;
				button.style.marginLeft = slider_position + "px";
				value_max = slider_div.getAttribute("data-max-value");
				value_min = parseFloat(slider_div.getAttribute("data-min-value") || 0);
        decimals = parseInt(slider_div.getAttribute("data-decimals") || 2);
        round_factor = Math.pow(10, decimals)
				value = value_min+(slider_position/slider_width*(value_max-value_min));
				value = Math.round(parseFloat(value) * round_factor) / round_factor;
				slider_id = slider_div.id;
        if(slider_id != ""){
          input_id = slider_id.replace("_slider", "");
          document.getElementById(input_id).value = value;
          callback = slider_div.getAttribute("data-callback");
          eval(callback);
        }
			}
			
			button.onmousedown=function(e){
				//Set x_down from cursor x
				if(!e) e = window.event;
				x_down = e.screenX;
				slider_start = parseInt(button.style.marginLeft)
				slider_div = this.parentNode
				slider_width = slider_div.offsetWidth - this.offsetWidth
			}
			document.onmousemove=function(e){
				//Get difference between x_down and cursor x, move button, return value
				if(!e) e = window.event;
				if(x_down){
					delta_x = e.screenX - x_down;
					slider_position = slider_start + delta_x
					if(slider_position < 0) slider_position = 0;
					if(slider_position > slider_width) slider_position = slider_width;
					button.style.marginLeft = slider_position + "px";
					value_max = slider_div.getAttribute("data-max-value");
					value_min = parseFloat(slider_div.getAttribute("data-min-value") || 0);
					decimals = parseInt(slider_div.getAttribute("data-decimals") || 2);
          round_factor = Math.pow(10, decimals)
					value = value_min+(slider_position/slider_width*(value_max-value_min));
					value = Math.round(parseFloat(value) * round_factor) / round_factor;
					slider_id = slider_div.id;
					input_id = slider_id.replace("_slider", "");
					document.getElementById(input_id).value = value;
					callback = slider_div.getAttribute("data-callback");
          eval(callback);
				}
			}
			document.onmouseup=function(e){
				//Stop moving slider
				if(x_down){
					x_down = 0
				}
			}
			
		}
	}
}

function slider_update_value(slider_index){
	//Set position of slider from corresponding input
	
	//Fins slider div from index
	divs = document.getElementsByTagName("div");
	slider_index_counter = 0
	slider_div;
	for(i=0;i<divs.length;i++){
		slider_div = divs[i]
		if(slider_div.className == "slider"){
			if(slider_index_counter == slider_index){
				break;
			}
			slider_index_counter++;
		}
	}
	
	//Update position
	button = slider_div.getElementsByTagName("button")[0];
	slider_id = slider_div.id;
	input_id = slider_id.replace("_slider", "");
	value = parseFloat(document.getElementById(input_id).value);
	if(isNaN(value)) value = 0;
	slider_width = slider_div.offsetWidth - button.offsetWidth
	value_max = slider_div.getAttribute("data-max-value");
	value_min = parseFloat(slider_div.getAttribute("data-min-value") || 0);
	slider_position = slider_width*(value-value_min)/(value_max-value_min)
	if(slider_position < 0) slider_position = 0;
	if(slider_position > slider_width) slider_position = slider_width;
	button.style.marginLeft = slider_position + "px";
}